#version 330 core

uniform mat4 ModelViewMatrix;
uniform mat4 ModelViewProjectionMatrix;

in vec3 gs_params[1]; // radius, energy, 1/mass

out vec3 ec_pos;
out vec2 pos_zw;
out vec2 uv;

layout(points) in;
layout(triangle_strip, max_vertices = 4) out;

#define EMIT_VERTEX(VTX, UV) \
	uv = UV; \
	ec_pos = vec3(ModelViewMatrix * vec4(VTX, 1.0)); \
	gl_Position = ModelViewProjectionMatrix * vec4(VTX, 1.0); \
	pos_zw = gl_Position.zw; \
	EmitVertex()

#include <matrix_include.vert>

void main()
{
	const vec3 XAxis = vec3(1.0, 0.0, 0.0);
	const vec3 YAxis = vec3(0.0, 1.0, 0.0);

	vec3 pos = gl_in[0].gl_Position.xyz;
	float radius = gs_params[0].x;

	vec3 axis = mix(pos.yzx, pos.zxy, 1.0 - gs_params[0].y);
	mat3 mr;
	rotate_around_axis(normalize(axis), gs_params[0].y*6.0, mr);

	vec3 a = pos + mr*((XAxis + YAxis)*radius);
	vec3 b = pos + mr*((YAxis - XAxis)*radius);
	vec3 c = pos + mr*((-XAxis - YAxis)*radius);
	vec3 d = pos + mr*((XAxis - YAxis)*radius);

	EMIT_VERTEX(a, vec2(1.0, 0.0));
	EMIT_VERTEX(b, vec2(0.0, 0.0));
	EMIT_VERTEX(d, vec2(1.0, 1.0));
	EMIT_VERTEX(c, vec2(0.0, 1.0));

	EndPrimitive();
}
